
package w83b.w83bUtilidadesComunes;

import java.text.NumberFormat;
import java.util.Locale;



import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesException;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;

public class W83bI18n implements java.io.Serializable{//NOPMD

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	public static final String ES_STR = "es";

	public static final String EU_STR = "eu";

	public static final Locale ES = new Locale(ES_STR);

	public static final Locale EU = new Locale(EU_STR);

	/**
	 * Metodo para obtener un texto de un fichero de definicion de cadenas para
	 * los diferentes idiomas.
	 * 
	 * @param ambito,
	 *            Ambito de cadenas definido en la configuracion de textos para
	 *            el framework Q70
	 * @param key,
	 *            Clave del texto a buscar
	 * @param idioma,
	 *            idioma seleccionado. Este idioma se puede obtener a partir de
	 *            la request de la forma: String idioma =
	 *            Q70ListenerUtils.getLanguage(request);
	 * @return
	 * @throws Q70GestorMensajesException
	 * @throws IllegalArgumentException,
	 *             si alguno de los parametros es nulo
	 */
	public static String getI18nProperty(String ambito, String key,
			String idioma) throws Q70GestorMensajesException,
			IllegalArgumentException {
		if (ambito == null || key == null || idioma == null)
			{throw new IllegalArgumentException(
					"Se ha producido un error al buscar la propiedad de ambito:"
							+ ambito + ", key:" + key + ", idioma:" + idioma);}

		Q70GestorMensajesi18n mensajes = Q70GestorMensajesi18n.getSingleton();
		return mensajes.getMessage(ambito, key, idioma);
	}

	public static String getI18nProperty(String ambito, String key,
			String idioma, String[] args) throws Q70GestorMensajesException,
			IllegalArgumentException {
		if (ambito == null || key == null || idioma == null)
			{throw new IllegalArgumentException(
					"Se ha producido un error al buscar la propiedad de ambito:"
							+ ambito + ", key:" + key + ", idioma:" + idioma);}

		Q70GestorMensajesi18n mensajes = Q70GestorMensajesi18n.getSingleton();
		return mensajes.getMessage(ambito,key,idioma,args);
		
	}

	public static String getNumericLanguage(String language) {
		return (language.equals(W83bI18n.ES_STR)) ? String
				.valueOf(2) : String.valueOf(1);
	}

	public static Locale getLocale(String language) {
		return (language.equals(W83bI18n.ES_STR)) ? ES : EU;
	}

	public static String formatNumber(double number) {
		String rdo = NumberFormat.getCurrencyInstance(ES).format(number);
		rdo = rdo.substring(1, rdo.length()) + " &euro;";
		return rdo;
	}

}